<?php

class Cookie extends CookieCore
{
    public function __construct($name, $path = '', $expire = null, $shared_urls = null, $standalone = false, $secure = false)
    {
        $this->_content = array();
        $this->_standalone = $standalone;
        $this->_expire = is_null($expire) ? time() + 1728000 : (int)$expire;
        $this->_path = trim(($this->_standalone ? '' : Context::getContext()->shop->physical_uri).$path, '/\\').'/';
        if ($this->_path{0} != '/') {
            $this->_path = '/'.$this->_path;
        }
        $this->_path = rawurlencode($this->_path);
        $this->_path = str_replace('%2F', '/', $this->_path);
        $this->_path = str_replace('%7E', '~', $this->_path);
        $this->_domain = $this->getDomain($shared_urls);

		// START Bugfix cache error
        //remove www from url > example: .domain.com
        $this->_domain =str_replace('www','', $this->_domain);

        //Change cookie name "PrestaShop" > "MyCookieName"
        $this->_name = 'MyCookieName-'.md5(($this->_standalone ? '' : _PS_VERSION_).$name.$this->_domain);
		// END Bugfix cache error
		
        $this->_allow_writing = true;
        $this->_salt = $this->_standalone ? str_pad('', 8, md5('ps'.__FILE__)) : _COOKIE_IV_;
        if ($this->_standalone) {
            $this->_cipherTool = new Blowfish(str_pad('', 56, md5('ps'.__FILE__)), str_pad('', 56, md5('iv'.__FILE__)));
        } elseif (!Configuration::get('PS_CIPHER_ALGORITHM') || !defined('_RIJNDAEL_KEY_')) {
            $this->_cipherTool = new Blowfish(_COOKIE_KEY_, _COOKIE_IV_);
        } else {
            $this->_cipherTool = new Rijndael(_RIJNDAEL_KEY_, _RIJNDAEL_IV_);
        }
        $this->_secure = (bool)$secure;

        $this->update();
    }
}